<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use MongoDB\Laravel\Eloquent\Model as MongoModel;

class Entry extends MongoModel
{

    protected $fillable = [
        'title',
        'description',
        'pages',
        'start_date',
        'end_date',
        'publish_date',
        'notes',
        'cover',

        'type_id',
        'publisher_id',
    ];

    public function type(): BelongsTo {
        return $this->belongsTo(Type::class);
    }

    public function publisher(): BelongsTo {
        return $this->belongsTo(Publisher::class);
    }

    public function tags(): BelongsToMany {
        return $this->belongsToMany(Tag::class, null, 'entry_ids', 'tag_ids');
    }

    /**
     * Sync tags by its title
     * @param array $tagTitles string[] of titles
     */
    public function syncTagsByTitle(array $tagTitles) {
        $tagsWhereTitle = Tag::select(['_id', 'title'])->whereIn('title', $tagTitles);
        $tagIds = $tagsWhereTitle->pluck('_id')->toArray();

        // Create non-existent tags
        $tagsTitles = $tagsWhereTitle->pluck('title')->toArray();
        $newTags = array_diff($tagTitles, $tagsTitles);
        foreach($newTags as $newTag) {
            $tag = Tag::create(['title' => $newTag]);
            $tagIds[] = $tag->id;
        }

        $this->tags()->detach();
        $this->tags()->attach($tagIds);
    }

}
